package ru.yandex.webmaster3.viewer.http.links;

import lombok.Data;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.link.BrokenLinkSample;

import java.util.List;

/**
 * @author leonidrom
 */
@Data
public class BrokenLinkSamplesGroup {
    private final String dstUrl;
    private final DateTime latestDate;
    private final List<HttpCodeInfo> dstHttpCodes;
    private final List<String> srcUrls;

    public static BrokenLinkSamplesGroup create(String dstUrl, List<BrokenLinkSample> samples) {
        List<HttpCodeInfo> dstHttpCodes = samples.stream()
                .map(BrokenLinkSample::getDstHttpCodeInfo)
                .distinct()
                .toList();

        DateTime latestDate = samples.stream()
                .map(BrokenLinkSample::getLinkDate)
                .max(AbstractInstant::compareTo)
                .get();

        List<String> srcUrls = samples.stream()
                .map(BrokenLinkSample::getSrcUrl)
                .distinct()
                .toList();

        return new BrokenLinkSamplesGroup(dstUrl, latestDate, dstHttpCodes, srcUrls);
    }
}
