package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import ru.yandex.webmaster3.core.link.DatePoint;

/**
 * @author aherman
 */
public interface DateHistory<T> {
    public List<? extends History<T>> getHistories();

    public interface History<T> {
        @JsonIgnore
        T getIndicatorName();

        default public IndicatorContainer<T> getIndicator() {
            return new IndicatorContainer<>(getIndicatorName());
        }
        public List<DatePoint> getData();
    }

    public static class IndicatorContainer<T> {
        private final T indicator;

        public IndicatorContainer(T indicator) {
            this.indicator = indicator;
        }

        public T getName() {
            return indicator;
        }
    }
}
