package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * @author aherman
 */
public interface DateTimeHistory<T> {
    public List<? extends History<T>> getHistories();

    public static interface History<T> {
        @JsonIgnore
        T getIndicatorName();

        default public IndicatorContainer<T> getIndicator() {
            return new IndicatorContainer<>(getIndicatorName());
        }
        public List<DateTimePoint> getData();
    }

    public static class IndicatorContainer<T> {
        private final T indicator;

        IndicatorContainer(T indicator) {
            this.indicator = indicator;
        }

        public T getName() {
            return indicator;
        };
    }
}
