package ru.yandex.webmaster3.viewer.http.links;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.link.BrokenLinkSample;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.links.BrokenLinkSamplesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

import java.util.*;

/**
 * @author leonidrom
 */
@ReadAction
@Category("links")
@Component("/links/broken/samples")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class GetBrokenLinkSamplesAction extends AbstractUserVerifiedHostAction<GetBrokenLinkSamplesRequest, GetBrokenLinkSamplesResponse> {
    private final BrokenLinkSamplesService brokenLinkSamplesService;

    @Override
    public GetBrokenLinkSamplesResponse process(GetBrokenLinkSamplesRequest request) {
        // получим все сэмплы
        List<BrokenLinkSample> samples = brokenLinkSamplesService.getRecentSamplesForLinkType(
                request.getHostId(), request.getLinkType());

        // сгруппируем их по урлу "Куда"
        Map<String, List<BrokenLinkSample>> mapByDstUrl = new HashMap<>();
        for (var sample: samples) {
            mapByDstUrl.computeIfAbsent(sample.getDstUrl(), k -> new ArrayList<>()).add(sample);
        }

        List<BrokenLinkSamplesGroup> samplesGroups = mapByDstUrl.entrySet().stream()
                .map(e -> BrokenLinkSamplesGroup.create(e.getKey(), e.getValue()))
                .sorted(Comparator.comparing(BrokenLinkSamplesGroup::getLatestDate).reversed())
                .toList();

        long samplesCount = brokenLinkSamplesService.getSamplesCountForLinkType(
                request.getHostId(), request.getLinkType());
        return new GetBrokenLinkSamplesResponse.NormalResponse(samplesGroups, samplesCount);
    }
}
