package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.link.DatePoint;

/**
 * @author aherman
 */
public abstract class GetInternalLinkBrokenHistoryResponse implements ActionResponse {
    public static class NormalResponse extends GetInternalLinkBrokenHistoryResponse
            implements DateHistory<LinkIndicator.Broken>, ActionResponse.NormalResponse {

        private final List<BrokenGroupHistory> histories;

        public NormalResponse(List<BrokenGroupHistory> histories) {
            this.histories = histories;
        }

        public List<BrokenGroupHistory> getHistories() {
            return histories;
        }
    }

    public static class BrokenGroupHistory implements DateHistory.History<LinkIndicator.Broken> {
        private final LinkIndicator.Broken indicator;
        private final List<DatePoint> data;

        public BrokenGroupHistory(LinkIndicator.Broken indicator, List<DatePoint> data) {
            this.indicator = indicator;
            this.data = data;
        }

        @Override
        public LinkIndicator.Broken getIndicatorName() {
            return indicator;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
