package ru.yandex.webmaster3.viewer.http.links;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.codes.ErrorGroupEnum;
import ru.yandex.webmaster3.core.codes.HttpCodeGroup;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.link.HostLinkSample;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.links2.Link2SamplesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

/**
 * @author aherman
 */
@ReadAction
@Category("links")
public class GetInternalLinkBrokenHttpCodeSamplesAction
        extends AbstractUserVerifiedHostAction<GetInternalLinkBrokenHttpCodeSamplesRequest, LinkSamplesResponse>
{
    private Link2SamplesService link2SamplesService;
    private LinkIndicator.Broken indicator;

    @Override
    public LinkSamplesResponse process(GetInternalLinkBrokenHttpCodeSamplesRequest request) {
        Set<Integer> httpFilter = getHttpFilter(request.getIndicators());
        long totalSamples = link2SamplesService.countInternalSamples(request.getHostId(), httpFilter);

        PageUtils.LongPager page = PageUtils.getPage(request.getPage(), request.getPageSize(), totalSamples);
        if (page.isEmpty()) {
            return new LinkSamplesResponse.NormalResponse(Collections.emptyList(), totalSamples);
        }

        List<HostLinkSample> samples = link2SamplesService.listInternalSamples(request.getHostId(), httpFilter,
                page.toRangeStart(), page.getPageSize());

        return new LinkSamplesResponse.NormalResponse(samples, totalSamples);
    }

    @NotNull
    private Set<Integer> getHttpFilter(HttpCodeGroup[] indicators) {
        Set<Integer> httpFilter;
        if (!ArrayUtils.isEmpty(indicators)) {
            httpFilter = new HashSet<>();
            for (YandexHttpStatus httpStatus : YandexHttpStatus.values()) {
                HttpCodeGroup group = HttpCodeGroup.get(httpStatus.getCode());
                if (ArrayUtils.contains(indicators, group)) {
                    httpFilter.add(httpStatus.getCode());
                }
            }
        } else {
            httpFilter = new HashSet<>();
            ErrorGroupEnum errorGroup = LinkIndicator.toGroup(indicator);
            for (YandexHttpStatus httpStatus : YandexHttpStatus.values()) {
                HttpCodeGroup codeGroup = HttpCodeGroup.get(httpStatus.getCode());
                if (errorGroup.contains(codeGroup)) {
                    httpFilter.add(httpStatus.getCode());
                }
            }
        }
        return httpFilter;
    }

    @Required
    public void setLink2SamplesService(Link2SamplesService link2SamplesService) {
        this.link2SamplesService = link2SamplesService;
    }

    @Required
    public void setIndicator(LinkIndicator.Broken indicator) {
        this.indicator = indicator;
    }
}
