package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;

import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.link.DatePoint;

/**
 * @author aherman
 */
public abstract class GetInternalLinkBrokenHttpCodesHistoryResponse implements ActionResponse {
    public static class NormalResponse extends GetInternalLinkBrokenHttpCodesHistoryResponse
            implements HttpCodeDateHistory, ActionResponse.NormalResponse {

        private final List<HttpCodeHistory> histories;

        public NormalResponse(List<HttpCodeHistory> histories) {
            this.histories = histories;
        }

        public List<HttpCodeHistory> getHistories() {
            return histories;
        }
    }

    public static class HttpCodeHistory implements HttpCodeDateHistory.History {
        private final HttpCodeInfo indicator;
        private final List<DatePoint> data;

        public HttpCodeHistory(HttpCodeInfo indicator,List<DatePoint> data) {
            this.indicator = indicator;
            this.data = data;
        }

        public HttpCodeInfo getIndicatorName() {
            return indicator;
        }

        public List<DatePoint> getData() {
            return data;
        }
    }
}
