package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author aherman
 */
public abstract class GetLinkIndicatorsTreeResponse implements ActionResponse {
    public static class NormalResponse extends GetLinkIndicatorsTreeResponse implements ActionResponse.NormalResponse {
        private final List<Node> indicators;

        public NormalResponse(List<Node> indicators) {
            this.indicators = indicators;
        }

        public List<Node> getIndicators() {
            return indicators;
        }
    }

    public static class Node {
        private final LinkIndicator.All name;

        public Node(LinkIndicator.All name) {
            this.name = name;
        }

        public LinkIndicator.All getName() {
            return name;
        }
    }
}
