package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.link.DatePoint;

/**
 * User: azakharov
 * Date: 24.06.15
 * Time: 16:51
 */
public abstract class GetLinksHistoryResponse implements ActionResponse {
    public static enum Indicator {
        LINKS_INTERNAL,
        LINKS_EXTERNAL
    }

    public static class OrdinaryResponse extends GetLinksHistoryResponse
            implements DateHistory<Indicator>, ActionResponse.NormalResponse {

        private List<LinkHistory> histories;

        public OrdinaryResponse(List<LinkHistory> histories) {
            this.histories = histories;
        }

        @Override
        public List<LinkHistory> getHistories() {
            return histories;
        }
    }

    public static class LinkHistory implements DateHistory.History<Indicator> {
        private final Indicator indicator;
        private final List<DatePoint> data;

        public LinkHistory(Indicator indicator, List<DatePoint> data) {
            this.indicator = indicator;
            this.data = data;
        }

        @Override
        public Indicator getIndicatorName() {
            return indicator;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
