package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.link.DatePoint;

/**
 * @author aherman
 */
public class HistoryUtil {
    public static NavigableMap<LocalDate, Long> merge(NavigableMap<LocalDate, Long> history1, NavigableMap<LocalDate, Long> history2) {
        if (history1.isEmpty()) {
            return history2;
        } else if (history2.isEmpty()) {
            return history1;
        }

        TreeMap<LocalDate, Long> result = new TreeMap<>(history1);
        for (Map.Entry<LocalDate, Long> entry : history2.entrySet()) {
            result.merge(entry.getKey(), entry.getValue(), (x,y) -> x + y);
        }

        return result;
    }

    public static List<DatePoint> toDataPoint(NavigableMap<LocalDate, Long> value) {
        return value.entrySet().stream().map(e -> new DatePoint(e.getKey(), e.getValue())).collect(Collectors.toList());
    }
}
