package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.webmaster3.core.codes.HttpCodeGroup;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.link.DatePoint;

/**
 * @author aherman
 */
public interface HttpCodeDateHistory {
    public List<? extends History> getHistories();

    public interface History {
        @JsonIgnore
        HttpCodeInfo getIndicatorName();

        default public IndicatorContainer getIndicator() {
            return new IndicatorContainer(getIndicatorName());
        }
        public List<DatePoint> getData();
    }

    public static class IndicatorContainer {
        private final HttpCodeInfo httpCodeInfo;

        IndicatorContainer(HttpCodeInfo httpCodeInfo) {
            this.httpCodeInfo = httpCodeInfo;
        }

        public HttpCodeGroup getName() {
            return httpCodeInfo.getHttpCodeGroup();
        }

        public HttpCodeInfo getHttpCodeInfo() {
            return httpCodeInfo;
        }
    }

}
