package ru.yandex.webmaster3.viewer.http.links;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.codes.LinkType;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.codes.ErrorGroupEnum;

/**
 * @author aherman
 */
public class LinkIndicator {
    public enum All {
        LINKS,
        LINKS_EXTERNAL,
        LINKS_INTERNAL,
        LINKS_INTERNAL_NORMAL,
        LINKS_INTERNAL_REDIRECT,
        LINKS_INTERNAL_BROKEN,
        LINKS_INTERNAL_BROKEN_SITE_ERROR,
        LINKS_INTERNAL_BROKEN_DISALLOWED_BY_USER,
        LINKS_INTERNAL_BROKEN_UNSUPPORTED_BY_ROBOT,
        LINKS_INTERNAL_NOT_DOWNLOADED
    }

    public enum Internal {
        LINKS_INTERNAL_NORMAL,
        LINKS_INTERNAL_REDIRECT,
        LINKS_INTERNAL_BROKEN,
        LINKS_INTERNAL_NOT_DOWNLOADED,
    }

    public enum Broken {
        LINKS_INTERNAL_BROKEN_SITE_ERROR,
        LINKS_INTERNAL_BROKEN_DISALLOWED_BY_USER,
        LINKS_INTERNAL_BROKEN_UNSUPPORTED_BY_ROBOT,
    }

    public static LinkType asType(Internal indicator) {
        switch (indicator) {
            case LINKS_INTERNAL_NORMAL: return LinkType.NORMAL;
            case LINKS_INTERNAL_REDIRECT: return LinkType.REDIRECT;
            case LINKS_INTERNAL_BROKEN: return LinkType.BROKEN;
            case LINKS_INTERNAL_NOT_DOWNLOADED: return LinkType.NOT_DOWNLOADED;
        }

        throw new WebmasterException("Missing indicator: " + indicator,
                new WebmasterErrorResponse.InternalUnknownErrorResponse(LinkIndicator.class,
                        "Missing indicator: " + indicator));
    }

    public static ErrorGroupEnum toGroup(Broken indicator) {
        switch (indicator) {
            case LINKS_INTERNAL_BROKEN_DISALLOWED_BY_USER: return ErrorGroupEnum.DISALLOWED_BY_USER;
            case LINKS_INTERNAL_BROKEN_SITE_ERROR: return ErrorGroupEnum.SITE_ERROR;
            case LINKS_INTERNAL_BROKEN_UNSUPPORTED_BY_ROBOT: return ErrorGroupEnum.UNSUPPORTED_BY_ROBOT;
        }
        throw new WebmasterException("Missing indicator: " + indicator,
                new WebmasterErrorResponse.InternalUnknownErrorResponse(LinkIndicator.class,
                        "Missing indicator: " + indicator));
    }

    public static Broken fromGroup(ErrorGroupEnum group) {
        switch (group) {
            case DISALLOWED_BY_USER: return Broken.LINKS_INTERNAL_BROKEN_DISALLOWED_BY_USER;
            case SITE_ERROR: return Broken.LINKS_INTERNAL_BROKEN_SITE_ERROR;
            case UNSUPPORTED_BY_ROBOT: return Broken.LINKS_INTERNAL_BROKEN_UNSUPPORTED_BY_ROBOT;
        }
        throw new WebmasterException("Missing group: " + group,
                new WebmasterErrorResponse.InternalUnknownErrorResponse(LinkIndicator.class,
                        "Missing group: " + group));
    }

    public static All brokenToAll(Broken indicator){
        switch (indicator){
            case LINKS_INTERNAL_BROKEN_DISALLOWED_BY_USER: return All.LINKS_INTERNAL_BROKEN_DISALLOWED_BY_USER;
            case LINKS_INTERNAL_BROKEN_SITE_ERROR: return All.LINKS_INTERNAL_BROKEN_SITE_ERROR;
            case LINKS_INTERNAL_BROKEN_UNSUPPORTED_BY_ROBOT: return All.LINKS_INTERNAL_BROKEN_UNSUPPORTED_BY_ROBOT;
        }
        throw new WebmasterException("Missing broken indicator: " + indicator,
                new WebmasterErrorResponse.InternalUnknownErrorResponse(LinkIndicator.class,
                        "Missing broken indicator: " + indicator));
    }

}
