package ru.yandex.webmaster3.viewer.http.links;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.link.HostLinkSample;

/**
 * @author aherman
 */
public abstract class LinkSamplesResponse implements ActionResponse {
    public static class NormalResponse extends LinkSamplesResponse implements ActionResponse.NormalResponse {
        private final List<HostLinkSample> samples;
        private final long totalSamples;

        public NormalResponse(List<HostLinkSample> samples, long totalSamples) {
            this.samples = samples;
            this.totalSamples = totalSamples;
        }

        public List<HostLinkSample> getSamples() {
            return samples;
        }

        public long getTotalSamples() {
            return totalSamples;
        }
    }
}
