package ru.yandex.webmaster3.viewer.http.links2;

import java.util.Collections;
import java.util.List;

import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.storage.links2.ExternalLinksGroupedOrder;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.OrderBy;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author tsyplyaev
 */
public class GetExternalLinkGroupBySourceSamplesRequest extends AbstractUserVerifiedHostRequest implements PagerAware {
    private int page = 0;
    private int pageSize = 20;

    private List<ViewerExtLinkFilter> parameterFilters = Collections.emptyList();

    private boolean filterBroken;
    private ExternalLinksGroupedOrder orderBy;
    private OrderBy.Direction orderDirection;
    private boolean deleted;

    @Override
    public void setP(int page) {
        this.page = page;
    }

    public int getPage() {
        return page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }

    public List<ViewerExtLinkFilter> getParameterFilters() {
        return parameterFilters;
    }

    @RequestQueryProperty
    public void setParameterFilters(List<ViewerExtLinkFilter> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }

    public boolean getFilterBroken() {
        return filterBroken;
    }

    @RequestQueryProperty
    public void setFilterBroken(boolean filterBroken) {
        this.filterBroken = filterBroken;
    }

    public ExternalLinksGroupedOrder getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    public void setOrderBy(ExternalLinksGroupedOrder orderBy) {
        this.orderBy = orderBy;
    }

    public OrderBy.Direction getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    public void setOrderDirection(OrderBy.Direction orderDirection) {
        this.orderDirection = orderDirection;
    }

    public boolean isDeleted() {
        return deleted;
    }

    @RequestQueryProperty
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}
