package ru.yandex.webmaster3.viewer.http.links2;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.links2.HostLinkSourceSample;

/**
 * @author tsyplyaev
 */
public abstract class GetExternalLinkGroupBySourceSamplesResponse implements ActionResponse {
    public static class NormalResponse extends GetExternalLinkGroupBySourceSamplesResponse implements ActionResponse.NormalResponse {
        private final List<HostLinkSourceSample> samples;
        private final long totalSamples;

        public NormalResponse(List<HostLinkSourceSample> samples, long totalSamples) {
            this.samples = samples;
            this.totalSamples = totalSamples;
        }

        public List<HostLinkSourceSample> getSamples() {
            return samples;
        }

        public long getTotalSamples() {
            return totalSamples;
        }
    }
}
