package ru.yandex.webmaster3.viewer.http.links2;

import java.util.Collections;
import java.util.List;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.storage.links2.ExternalLinksOrder;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.OrderBy;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.links.LinkIndicator;

/**
 * @author tsyplyaev
 */
public class GetExternalLinkSamplesRequest extends AbstractUserVerifiedHostRequest implements PagerAware {
    private LinkIndicator.Broken[] indicators;

    private int page = 0;
    private int pageSize = 20;
    private WebmasterHostId sourceHostId;
    private List<ViewerExtLinkFilter> parameterFilters = Collections.emptyList();
    private boolean filterBroken = false;

    private ExternalLinksOrder orderBy;
    private OrderBy.Direction orderDirection = OrderBy.Direction.ASC;

    private boolean deleted;

    @RequestPostProperty
    public void setIndicators(LinkIndicator.Broken[] indicators) {
        this.indicators = indicators;
    }

    public LinkIndicator.Broken[] getIndicators() {
        return indicators;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    public int getPage() {
        return page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }

    public WebmasterHostId getSourceHostId() {
        return sourceHostId;
    }

    @RequestQueryProperty
    public void setSourceHostId(WebmasterHostId sourceHostId) {
        this.sourceHostId = sourceHostId;
    }

    @RequestQueryProperty
    public void setFilterSourceHostId(WebmasterHostId filterSourceHostId) {
        this.sourceHostId = filterSourceHostId;
    }

    public ExternalLinksOrder getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    public void setOrderBy(ExternalLinksOrder orderBy) {
        this.orderBy = orderBy;
    }

    public boolean getFilterBroken() {
        return filterBroken;
    }

    @RequestQueryProperty
    public void setFilterBroken(Boolean filterBroken) {
        this.filterBroken = filterBroken;
    }

    public OrderBy.Direction getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    public void setOrderDirection(OrderBy.Direction orderDirection) {
        this.orderDirection = orderDirection;
    }

    public boolean isDeleted() {
        return deleted;
    }

    @RequestQueryProperty
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @RequestPostProperty
    public void setParameterFilters(List<ViewerExtLinkFilter> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }

    public List<ViewerExtLinkFilter> getParameterFilters() {
        return parameterFilters;
    }
}
