package ru.yandex.webmaster3.viewer.http.links2;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.link.LinkHistoryIndicatorType;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;
import ru.yandex.webmaster3.core.link.DatePoint;

import java.util.List;

/**
 * User: azakharov
 * Date: 24.06.15
 * Time: 16:51
 */
public abstract class GetExternalLinksHistoryResponse implements ActionResponse {
    public static class OrdinaryResponseLinks extends GetExternalLinksHistoryResponse
            implements DateHistory<LinkHistoryIndicatorType>, ActionResponse.NormalResponse {

        private List<LinkHistory> histories;

        public OrdinaryResponseLinks(List<LinkHistory> histories) {
            this.histories = histories;
        }

        @Override
        public List<LinkHistory> getHistories() {
            return histories;
        }
    }

    public static class LinkHistory implements DateHistory.History<LinkHistoryIndicatorType> {
        private final LinkHistoryIndicatorType indicator;
        private final List<DatePoint> data;

        public LinkHistory(LinkHistoryIndicatorType indicator, List<DatePoint> data) {
            this.indicator = indicator;
            this.data = data;
        }

        @Override
        public LinkHistoryIndicatorType getIndicatorName() {
            return indicator;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
