package ru.yandex.webmaster3.viewer.http.links2;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;
import ru.yandex.webmaster3.core.link.DatePoint;

import java.util.List;

/**
 * User: azakharov
 * Date: 24.06.15
 * Time: 16:51
 */
public abstract class GetLinksHistoryResponse implements ActionResponse {
    public enum Indicator {
        LINKS_EXTERNAL_URLS,
        LINKS_EXTERNAL_HOSTS,
        LINKS_EXTERNAL_NEW_URLS,
        LINKS_EXTERNAL_NEW_HOSTS,
        LINKS_EXTERNAL_GONE_URLS,
        LINKS_EXTERNAL_GONE_HOSTS,
        LINKS_EXTERNAL_BROKEN_URLS
    }

    public static class OrdinaryResponse extends GetLinksHistoryResponse
            implements DateHistory<Indicator>, ActionResponse.NormalResponse {

        private List<LinkHistory> histories;

        public OrdinaryResponse(List<LinkHistory> histories) {
            this.histories = histories;
        }

        @Override
        public List<LinkHistory> getHistories() {
            return histories;
        }
    }

    public static class LinkHistory implements DateHistory.History<Indicator> {
        private final Indicator indicator;
        private final List<DatePoint> data;

        public LinkHistory(Indicator indicator, List<DatePoint> data) {
            this.indicator = indicator;
            this.data = data;
        }

        @Override
        public Indicator getIndicatorName() {
            return indicator;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
