package ru.yandex.webmaster3.viewer.http.messages;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.service.NewUserMessagesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * Created by kravchenko99 on 23.10.19.
 */
@WriteAction
@Description(value = "Удалить все сообщения")
@Category("notifications")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/messages/deleteAll")
public class DeleteAllMessagesAction extends AbstractUserAction<DeleteAllMessagesAction.Request, DeleteAllMessagesAction.NormalResponse> {
    private final NewUserMessagesService newUserMessagesService;

    @Override
    public NormalResponse process(Request request) {
        newUserMessagesService.deleteAllMessages(request.getUserId());
        return new NormalResponse();
    }

    public static class Request extends AbstractUserRequest {
    }

    public static class NormalResponse implements ActionResponse.NormalResponse {
    }
}
