package ru.yandex.webmaster3.viewer.http.messages;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.service.NewUserMessagesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;

/**
 * Created by ifilippov5 on 20.04.17.
 */
@WriteAction
@Description(value = "Удалить сообщение")
@Category("notifications")
public class DeleteMessagesAction extends AbstractUserAction<DeleteMessagesRequest, DeleteMessagesResponse> {
    private NewUserMessagesService newUserMessagesService;

    @Override
    public DeleteMessagesResponse process(DeleteMessagesRequest request) {
        newUserMessagesService.deleteMessages(request.getUserId(), Cf.list(request.getMessageIds()));
        return new DeleteMessagesResponse.NormalResponse();
    }

    @Required
    public void setNewUserMessagesService(NewUserMessagesService newUserMessagesService) {
        this.newUserMessagesService = newUserMessagesService;
    }
}
