package ru.yandex.webmaster3.viewer.http.messages;

import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.message.MessageId;
import ru.yandex.webmaster3.storage.user.message.MessagesFilter;
import ru.yandex.webmaster3.storage.user.message.UserMessageInfo;
import ru.yandex.webmaster3.storage.user.service.NewUserMessagesService;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseException;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;

/**
 * Created by ifilippov5 on 19.04.17.
 */
@ReadAction
@Description(value = "Получить информацию о сообщении")
@Category("notifications")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetMessageAction extends AbstractUserAction<GetMessageRequest, GetMessageResponse> {
    private final NewUserMessagesService newUserMessagesService;

    @Override
    public GetMessageResponse process(GetMessageRequest request) {
        MessagesFilter filter = new MessagesFilter(request.isOnlyCritical(), request.isOnlyUnread(), request.getHostId());
        UserMessageInfo messageInfo;
        MessageId prevMessageId;
        MessageId nextMessageId;
        try {
            messageInfo = newUserMessagesService.getMessage(request.getUserId(), request.getMessageId());
            if (messageInfo == null) {
                return new GetMessageResponse.MessageNotFoundResponse(this.getClass());
            }
             Pair<MessageId, MessageId> pair =
                     newUserMessagesService.getPreviousAndNextMessageId(request.getUserId(), messageInfo, filter);
             prevMessageId = pair.getLeft();
             nextMessageId = pair.getRight();
        } catch (ClickhouseException e) {
            throw new WebmasterException("Unable to get message",
                    new WebmasterErrorResponse.ClickhouseErrorResponse(this.getClass(), null, e), e);
        }
        return new GetMessageResponse.NormalResponse(messageInfo, nextMessageId, prevMessageId);
    }
}
