package ru.yandex.webmaster3.viewer.http.messages;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.user.message.MessageId;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * @author avhaliullin
 */
public class GetMessageRequest extends AbstractUserRequest implements MessagesFilterAware {
    private MessageId messageId;
    private boolean onlyCritical = false;
    private boolean onlyUnread = false;
    private WebmasterHostId hostId;

    public MessageId getMessageId() {
        return messageId;
    }

    @Description(value = "Идентификатор сообщения. Формат: {eventUuid}-{hash в 16 системе счисления}")
    @RequestQueryProperty(required = true)
    public void setMessageId(MessageId messageId) {
        this.messageId = messageId;
    }

    @Override
    public boolean isOnlyCritical() {
        return onlyCritical;
    }

    @Override
    public void setOnlyCritical(boolean onlyCritical) {
        this.onlyCritical = onlyCritical;
    }

    @Override
    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Override
    public boolean isOnlyUnread() {
        return onlyUnread;
    }

    @Override
    public void setOnlyUnread(boolean onlyUnread) {
        this.onlyUnread = onlyUnread;
    }

    @Override
    public void setHostId(WebmasterHostId hostId) {
        this.hostId = hostId;
    }
}
