package ru.yandex.webmaster3.viewer.http.messages;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.user.message.MessageId;
import ru.yandex.webmaster3.storage.user.message.UserMessageInfo;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public abstract class GetMessageResponse implements ActionResponse {
    public static class NormalResponse extends GetMessageResponse implements ActionResponse.NormalResponse {
        private final UserMessageInfo messageInfo;
        private final MessageId nextMessageId;
        private final MessageId prevMessageId;

        public NormalResponse(UserMessageInfo messageInfo, MessageId nextMessageId, MessageId prevMessageId) {
            this.messageInfo = messageInfo;
            this.nextMessageId = nextMessageId;
            this.prevMessageId = prevMessageId;
        }

        public UserMessageInfo getMessageInfo() {
            return messageInfo;
        }

        public MessageId getNextMessageId() {
            return nextMessageId;
        }

        public MessageId getPrevMessageId() {
            return prevMessageId;
        }
    }

    public static enum GetMessageErrorType {
        GET_MESSAGE__MESSAGE_NOT_FOUND
    }

    public static class MessageNotFoundResponse extends GetMessageResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;

        public MessageNotFoundResponse(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Enum<?> getCode() {
            return GetMessageErrorType.GET_MESSAGE__MESSAGE_NOT_FOUND;
        }

        @Override
        public Class<?> getClazz() {
            return clazz;
        }

        @Override
        public String getMessage() {
            return "Message not found";
        }
    }
}
