package ru.yandex.webmaster3.viewer.http.messages;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.user.message.MessagesFilter;
import ru.yandex.webmaster3.storage.user.message.UserMessageInfo;
import ru.yandex.webmaster3.storage.user.service.NewUserMessagesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;

import java.util.List;

/**
 * Created by ifilippov5 on 13.04.17.
 */
@ReadAction
@Description(value = "Список сообщений пользователя")
@Category("notifications")
public class ListMessagesAction extends AbstractUserAction<ListMessagesRequest, ListMessagesResponse> {
    private NewUserMessagesService newUserMessagesService;

    @Override
    public ListMessagesResponse process(ListMessagesRequest request) throws WebmasterException {
        MessagesFilter filter = new MessagesFilter(request.isOnlyCritical(), request.isOnlyUnread(), request.getHostId());
        Pair<List<UserMessageInfo>, Long> pair = newUserMessagesService.listAndCountMessages(
                request.getUserId(), filter, PageUtils.getPage(request.getP(), request.getPSize()));
        return new ListMessagesResponse.NormalResponse(pair.getLeft(), pair.getRight());
    }

    @Required
    public void setNewUserMessagesService(NewUserMessagesService newUserMessagesService) {
        this.newUserMessagesService = newUserMessagesService;
    }
}
