package ru.yandex.webmaster3.viewer.http.messages;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * @author avhaliullin
 */
public class ListMessagesRequest extends AbstractUserRequest implements PagerAware, MessagesFilterAware {
    private boolean onlyCritical = false;
    private boolean onlyUnread = false;
    private WebmasterHostId hostId;
    private int pSize = 20;
    private int page = 0;

    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Override
    public void setHostId(WebmasterHostId hostId) {
        this.hostId = hostId;
    }

    @Override
    public boolean isOnlyCritical() {
        return onlyCritical;
    }

    @Override
    public void setOnlyCritical(boolean onlyCritical) {
        this.onlyCritical = onlyCritical;
    }

    @Override
    public boolean isOnlyUnread() {
        return onlyUnread;
    }

    @Override
    public void setOnlyUnread(boolean onlyUnread) {
        this.onlyUnread = onlyUnread;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pSize = pageSize;
    }

    public int getPSize() {
        return pSize;
    }

    public int getP() {
        return page;
    }
}
