package ru.yandex.webmaster3.viewer.http.messages;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.user.message.UserMessageInfo;

/**
 * @author avhaliullin
 */
public abstract class ListMessagesResponse implements ActionResponse {
    public static class NormalResponse extends ListMessagesResponse implements ActionResponse.NormalResponse {
        private final List<UserMessageInfo> messages;
        private final long totalMessages;

        public NormalResponse(List<UserMessageInfo> messages, long totalMessages) {
            this.messages = messages;
            this.totalMessages = totalMessages;
        }

        public List<UserMessageInfo> getMessages() {
            return messages;
        }

        public long getTotalMessages() {
            return totalMessages;
        }
    }
}
