package ru.yandex.webmaster3.viewer.http.messages;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.service.NewUserMessagesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;

/**
 * Created by ifilippov5 on 20.04.17.
 */
@WriteAction
@Description(value = "Пометить сообщения как прочитанные")
@Category("notifications")
public class MarkReadAction extends AbstractUserAction<MarkReadRequest, MarkReadResponse> {
    private NewUserMessagesService newUserMessagesService;

    @Override
    public MarkReadResponse process(MarkReadRequest request) {
        newUserMessagesService.markRead(request.getUserId(), Cf.list(request.messageIds), request.isRead());
        return new MarkReadResponse.NormalResponse();
    }

    @Required
    public void setNewUserMessagesService(NewUserMessagesService newUserMessagesService) {
        this.newUserMessagesService = newUserMessagesService;
    }
}
