package ru.yandex.webmaster3.viewer.http.messages;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.service.NewUserMessagesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * Created by kravchenko99 on 23.10.19.
 */
@WriteAction
@Description(value = "Пометить все сообщения как прочитанные")
@Category("notifications")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/messages/markReadAll")
public class MarkReadAllAction extends AbstractUserAction<MarkReadAllAction.Request, MarkReadAllAction.NormalResponse> {
    private final NewUserMessagesService newUserMessagesService;

    @Override
    public NormalResponse process(Request request) {
        newUserMessagesService.markReadAll(request.getUserId(), true);
        return new NormalResponse();
    }

    public static class Request extends AbstractUserRequest {
    }

    public static class NormalResponse implements ActionResponse.NormalResponse {
    }
}
