package ru.yandex.webmaster3.viewer.http.messages;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.user.message.MessageId;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * @author avhaliullin
 */
public class MarkReadRequest extends AbstractUserRequest {
    private boolean read;
    MessageId[] messageIds;

    public MessageId[] getMessageIds() {
        return messageIds;
    }

    @Description(value="Список id сообщений")
    @RequestPostProperty(required = true)
    public void setMessageIds(MessageId[] messageIds) {
        this.messageIds = messageIds;
    }

    public boolean isRead() {
        return read;
    }

    @Description(value="Пометить как прочитанное")
    @RequestQueryProperty(required = true)
    public void setRead(boolean read) {
        this.read = read;
    }
}
