package ru.yandex.webmaster3.viewer.http.messages;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;

/**
 * @author avhaliullin
 */
public interface MessagesFilterAware {
    @Description(value = "Показывать только критичные сообщения")
    @RequestQueryProperty
    void setOnlyCritical(boolean onlyCritical);

    boolean isOnlyCritical();

    @Description("id хоста для фильтрации")
    @RequestQueryProperty
    void setHostId(WebmasterHostId hostId);

    @Description(value = "Показывать только прочитанные сообщения")
    @RequestQueryProperty
    void setOnlyUnread(boolean onlyUnread);

    boolean isOnlyUnread();

    WebmasterHostId getHostId();
}
