package ru.yandex.webmaster3.viewer.http.messages;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.service.NewUserMessagesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;

/**
 * Created by ifilippov5 on 21.04.17.
 */
@ReadAction
@Description("Общее количество непрочитанных уведомлений для пользователя")
@Category("notifications")
public class UnreadMessagesCountAction extends AbstractUserAction<UnreadMessagesCountRequest, UnreadMessagesCountResponse> {

    private NewUserMessagesService newUserMessagesService;

    @Override
    public UnreadMessagesCountResponse process(UnreadMessagesCountRequest request) {
        long count = newUserMessagesService.unreadCount(request.getUserId(), request.isInvalidateCache());
        return new UnreadMessagesCountResponse(count);
    }

    @Required
    public void setNewUserMessagesService(NewUserMessagesService newUserMessagesService) {
        this.newUserMessagesService = newUserMessagesService;
    }
}
