package ru.yandex.webmaster3.viewer.http.metrika.counter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.metrika.counters.MetrikaCounterBindingInfo;

/**
 * Created by ifilippov5 on 24.10.17.
 */
public abstract class BindCounterResponse implements ActionResponse {
    public static class NormalResponse extends BindCounterResponse implements ActionResponse.NormalResponse {
        private final MetrikaCounterBindingInfo counterInfo;

        public NormalResponse(MetrikaCounterBindingInfo counterInfo) {
            this.counterInfo = counterInfo;
        }

        @Description("информация о счетчике")
        public MetrikaCounterBindingInfo getCounterInfo() {
            return counterInfo;
        }

        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }

    public enum Errors {
        SYNCHRONIZATION_WITH_METRIKA_ERROR,
        COUNTER_DELETED,
        BINDING_ALREADY_EXISTS,
        WRONG_DOMAIN_FOR_COUNTER,
    }

    public abstract static class ErrorResponse extends BindCounterResponse implements ActionResponse.ErrorResponse {
        private final Errors errorCode;
        private final String message;

        public ErrorResponse(Errors code, String message) {
            this.errorCode = code;
            this.message = message;
        }

        @Override
        public Enum<?> getCode() {
            return errorCode;
        }

        public String getMessage() {
            return message;
        }
    }

    @Description("Счетчик метрики удален")
    public static class MetrikaCounterDeletedError extends ErrorResponse {
        public MetrikaCounterDeletedError(String message) {
            super(Errors.COUNTER_DELETED, message);
        }
    }

    @Description("Привязка уже существует")
    public static class BindingAlreadyExistsError extends ErrorResponse {
        public BindingAlreadyExistsError(String message) {
            super(Errors.BINDING_ALREADY_EXISTS, message);
        }
    }

    @Description("Счетчик в метрике настроен для другого домена и не может быть привязан к указанному")
    public static class WrongDomainForCounterError extends ErrorResponse {
        public WrongDomainForCounterError() { super(Errors.WRONG_DOMAIN_FOR_COUNTER, "Wrong domain"); }
    }
}
