package ru.yandex.webmaster3.viewer.http.metrika.counter;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.metrika.counters.SimpleCounterInfo;
import ru.yandex.webmaster3.storage.metrika.MetrikaCountersApiService;
import ru.yandex.webmaster3.storage.user.UserPersonalInfo;
import ru.yandex.webmaster3.storage.user.service.UserPersonalInfoService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

import java.util.Collections;
import java.util.List;

/**
 * Created by Oleg Bazdyrev on 2019-10-01.
 */
@ReadAction
@Description("Получение счетчиков пользователя")
@Component("/metrika/counter/list")
@Category("metrika")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class GetUserCountersAction extends AbstractUserAction<GetUserCountersAction.Request, GetUserCountersAction.Response> {

    private final MetrikaCountersApiService metrikaCountersApiService;
    private final UserPersonalInfoService userPersonalInfoService;

    @Override
    public Response process(Request request) {
        UserPersonalInfo userInfo = userPersonalInfoService.getUserPersonalInfo(request.getUserId());
        List<SimpleCounterInfo> counters = Collections.emptyList();
        if (userInfo != null) {
            counters = metrikaCountersApiService.getCountersList(userInfo.getLogin());
        }
        return new Response(counters);
    }

    public static final class Request extends AbstractUserRequest {

    }

    @Getter
    @RequiredArgsConstructor
    public static final class Response implements ActionResponse.NormalResponse {
        @Description("Счетчики метрики для пользователя")
        private final List<SimpleCounterInfo> counters;

    }
}
