package ru.yandex.webmaster3.viewer.http.metrika.counter.mock;

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrika.counters.CounterBindingStateEnum;
import ru.yandex.webmaster3.core.metrika.counters.MetrikaCountersUtil;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.storage.metrika.MetrikaCounterBindingService;
import ru.yandex.wmtools.common.util.uri.UriUtils;

/**
 * @author avhaliullin
 */
@WriteAction
public class MetrikaMockAction extends Action<MetrikaMockRequest, MetrikaMockResponse> {
    private final MetrikaCounterBindingService metrikaCounterBindingService;

    @Autowired
    public MetrikaMockAction(MetrikaCounterBindingService metrikaCounterBindingService) {
        this.metrikaCounterBindingService = metrikaCounterBindingService;
    }

    @Override
    public MetrikaMockResponse process(MetrikaMockRequest request) {
        String canonicalDomain = MetrikaCountersUtil.domainToCanonicalAscii(request.getDomain());
        UriUtils.verifyASCIIDomain(canonicalDomain);
        CounterBindingStateEnum state;
        state = metrikaCounterBindingService.getState(canonicalDomain, request.getCounterId());

        CounterBindingStateEnum newState = metrikaChange(state, request.getRequestType() == MockRequestType.APPROVE);
        String userLogin = metrikaCounterBindingService.getUserLogin(request.getUserId());

        metrikaCounterBindingService.updateStateWithMetrikaUser(canonicalDomain, newState, request.getCounterId(),
                userLogin, DateTime.now(TimeUtils.EUROPE_MOSCOW_ZONE), request.getUserId(), "mock");

        return new MetrikaMockResponse();
    }

    private static CounterBindingStateEnum metrikaChange(CounterBindingStateEnum state, boolean approved) {
        if (state.isMetrikaApproved() == approved) {
            return state;
        } else if (approved) {
            return state.isWebmasterApproved() ? CounterBindingStateEnum.APPROVED : CounterBindingStateEnum.METRIKA_REQUEST;
        } else {
            return state.isWebmasterApproved() ? CounterBindingStateEnum.METRIKA_REJECT : CounterBindingStateEnum.NONE;
        }
    }
}
