package ru.yandex.webmaster3.viewer.http.metrika.crawl;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author avhaliullin
 */
public class MetrikaCounterCrawlInfo {
    private final long counterId;
    private final boolean allowedCrawl;
    private final boolean verified;
    private final String name;

    public MetrikaCounterCrawlInfo(long counterId, boolean allowedCrawl, boolean verified, String name) {
        this.counterId = counterId;
        this.allowedCrawl = allowedCrawl;
        this.verified = verified;
        this.name = name;
    }

    @Description("id счетчика метрики")
    public long getCounterId() {
        return counterId;
    }

    @Description("для счетчика разрешен обход страниц")
    public boolean isAllowedCrawl() {
        return allowedCrawl;
    }

    @Description("провязка счетчика с хостом подтверждена")
    public boolean isVerified() {
        return verified;
    }

    @Description("название счетчика")
    public String getName() {
        return name;
    }
}
