package ru.yandex.webmaster3.viewer.http.metrika.crawl;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrika.counters.CounterBinding;
import ru.yandex.webmaster3.core.metrika.counters.CounterInfo;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.metrika.MetrikaCounterBindingService;
import ru.yandex.webmaster3.storage.metrika.MetrikaCountersApiService;
import ru.yandex.webmaster3.storage.metrika.MetrikaCrawlStateService;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaDomainCrawlState;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Настройки обхода роботом урлов из метрики")
@Deprecated
public class MetrikaCrawlSettingsAction extends Action<MetrikaCrawlSettingsRequest, MetrikaCrawlSettingsResponse> {
    private static final Comparator<MetrikaCounterCrawlInfo> COUNTER_COMPARATOR =
            Comparator.comparing(MetrikaCounterCrawlInfo::isVerified).reversed()
                    .thenComparing(MetrikaCounterCrawlInfo::getCounterId);

    private final MetrikaCrawlStateService metrikaCrawlStateService;
    private final MetrikaCounterBindingService metrikaCounterBindingService;
    private final MetrikaCountersApiService metrikaCountersApiService;

    @Autowired
    public MetrikaCrawlSettingsAction(
            MetrikaCrawlStateService metrikaCrawlStateService,
            MetrikaCounterBindingService metrikaCounterBindingService,
            MetrikaCountersApiService metrikaCountersApiService) {
        this.metrikaCrawlStateService = metrikaCrawlStateService;
        this.metrikaCounterBindingService = metrikaCounterBindingService;
        this.metrikaCountersApiService = metrikaCountersApiService;
    }

    @Override
    public MetrikaCrawlSettingsResponse process(MetrikaCrawlSettingsRequest request) throws WebmasterException {
        String targetDomain = WwwUtil.cutWww(request.getHostId().getASCIIHostname());
        MetrikaDomainCrawlState domainCrawlState = metrikaCrawlStateService.getDomainCrawlState(targetDomain);
        Set<Long> enabledCounterIds = new HashSet<>();
        enabledCounterIds.addAll(domainCrawlState.getEnabledCounters());
        enabledCounterIds.addAll(domainCrawlState.getSuspendedCounters()); // старая верстка ничего не знает про это состояние

        Map<Long, CounterBinding> domainBindings = metrikaCounterBindingService.getBindingsForDomain(targetDomain, true)
                .stream().collect(Collectors.toMap(CounterBinding::getCounterId, r -> r));
        List<MetrikaCounterCrawlInfo> selfCounters = domainBindings.keySet().stream()
                .map(binding -> getCounterInfo(binding, enabledCounterIds.contains(binding)))
                .sorted(COUNTER_COMPARATOR)
                .collect(Collectors.toList());

        return new MetrikaCrawlSettingsResponse(selfCounters);
    }

    private MetrikaCounterCrawlInfo getCounterInfo(long counterId, boolean allowedCrawl) {
        CounterInfo counter = metrikaCountersApiService.getCounterInfo(counterId);
        return new MetrikaCounterCrawlInfo(
                counterId,
                allowedCrawl,
                true,
                counter.getCounterName()
        );
    }
}
