package ru.yandex.webmaster3.viewer.http.metrika.crawl;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.metrika.MetrikaCrawlStateService;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaDomainCrawlState;

import java.util.Collections;
import java.util.Set;

/**
 * @author avhaliullin
 */
@WriteAction
@Description("Обновить настройки обхода по счетчикам метрики")
@Deprecated
public class UpdateMetrikaCrawlSettingsAction extends Action<UpdateMetrikaCrawlSettingsRequest, UpdateMetrikaCrawlSettingsResponse> {
    private final MetrikaCrawlStateService metrikaCrawlStateService;

    @Autowired
    public UpdateMetrikaCrawlSettingsAction(MetrikaCrawlStateService metrikaCrawlStateService) {
        this.metrikaCrawlStateService = metrikaCrawlStateService;
    }

    @Override
    public UpdateMetrikaCrawlSettingsResponse process(UpdateMetrikaCrawlSettingsRequest request) throws WebmasterException {
        try {
            String domain = WwwUtil.cutWww(request.getHostId().getASCIIHostname());
            Set<Long> enabledCounters = request.getEnabledCounters();
            if (enabledCounters == null) {
                enabledCounters = Collections.emptySet();
            }

            metrikaCrawlStateService.updateCrawlStateWithEnabled(domain, enabledCounters);

            return new UpdateMetrikaCrawlSettingsResponse.NormalResponse();
        } catch (WebmasterYdbException e) {
            throw e.asUnchecked();
        }
    }
}
