package ru.yandex.webmaster3.viewer.http.metrika.crawl;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.Set;

/**
 * @author avhaliullin
 */
public class UpdateMetrikaCrawlSettingsRequest extends AbstractUserVerifiedHostRequest {
    private boolean inheritanceEnabled; // TODO: оторвать
    private Set<Long> enabledCounters;

    public boolean isInheritanceEnabled() {
        return inheritanceEnabled;
    }

    @RequestQueryProperty(required = true)
    @Description("наследовать настройки с родителя")
    public void setInheritanceEnabled(boolean inheritanceEnabled) {
        this.inheritanceEnabled = inheritanceEnabled;
    }

    public Set<Long> getEnabledCounters() {
        return enabledCounters;
    }

    @Description("список счетчиков, для которых разрешен обход")
    @RequestQueryProperty(required = true)
    public void setEnabledCounters(Set<Long> enabledCounters) {
        this.enabledCounters = enabledCounters;
    }
}
