package ru.yandex.webmaster3.viewer.http.metrika.crawl2;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaCrawlSample;

import java.util.List;

/**
 * @author leonidrom
 */
public class MetrikaCrawlSamplesResponse implements ActionResponse.NormalResponse {
    private final long totalSamples;
    private final List<MetrikaCrawlSample> samples;
    private final DateTime lastUpdated;

    public MetrikaCrawlSamplesResponse(long totalSamples, List<MetrikaCrawlSample> samples, DateTime lastUpdated) {
        this.totalSamples = totalSamples;
        this.samples = samples;
        this.lastUpdated = lastUpdated;
    }

    @Description("Количество семплов")
    public long getTotalSamples() {
        return totalSamples;
    }

    @Description("Семплы")
    public List<MetrikaCrawlSample> getSamples() {
        return samples;
    }

    @Description("Дата последнего обновления")
    public DateTime getLastUpdated() {
        return lastUpdated;
    }
}
