package ru.yandex.webmaster3.viewer.http.metrika.crawl2;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.metrika.counters.CounterBinding;
import ru.yandex.webmaster3.core.metrika.counters.CounterInfo;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.metrika.MetrikaCrawlSamplesService;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaDomainCrawlState;
import ru.yandex.webmaster3.storage.metrika.MetrikaCounterBindingService;
import ru.yandex.webmaster3.storage.metrika.MetrikaCrawlStateService;
import ru.yandex.webmaster3.viewer.http.metrika.crawl2.data.MetrikaCounterCrawlInfo;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author leonidrom
 */
@ReadAction
@Category("metrika")
@Description("Настройки обхода роботом урлов из метрики")
public class MetrikaCrawlSettingsAction extends Action<MetrikaCrawlSettingsRequest, MetrikaCrawlSettingsResponse> {
    private static final Comparator<MetrikaCounterCrawlInfo> COUNTER_COMPARATOR =
            Comparator.comparing(MetrikaCounterCrawlInfo::isVerified).reversed()
                    .thenComparing(MetrikaCounterCrawlInfo::getCounterId);

    private final MetrikaCrawlStateService metrikaCrawlStateService;
    private final MetrikaCounterBindingService metrikaCounterBindingService;
    private final MetrikaCrawlSamplesService metrikaCrawlSamplesService;

    @Autowired
    public MetrikaCrawlSettingsAction(MetrikaCrawlStateService metrikaCrawlStateService, MetrikaCounterBindingService metrikaCounterBindingService, MetrikaCrawlSamplesService metrikaCrawlSamplesService) {
        this.metrikaCrawlStateService = metrikaCrawlStateService;
        this.metrikaCounterBindingService = metrikaCounterBindingService;
        this.metrikaCrawlSamplesService = metrikaCrawlSamplesService;
    }

    @Override
    public MetrikaCrawlSettingsResponse process(MetrikaCrawlSettingsRequest request) throws WebmasterException {
        String targetDomain = WwwUtil.cutWww(request.getHostId().getASCIIHostname());
        MetrikaDomainCrawlState domainCrawlState = metrikaCrawlStateService.getDomainCrawlState(targetDomain);

        List<CounterBinding> domainCounters = metrikaCounterBindingService.getBindingsForDomain(targetDomain, true);
        List<MetrikaCounterCrawlInfo> crawlInfos = domainCounters.stream()
                .map(cb -> {
                    long counterId = cb.getCounterId();
                    CounterInfo counterInfo = cb.isFake()?
                            CounterInfo.newFakeCounterInfo(counterId) :
                            metrikaCounterBindingService.getCounterInfo(counterId, targetDomain);
                    return new MetrikaCounterCrawlInfo(
                            counterId,
                            domainCrawlState.getMetrikaCounterCrawlState(counterId),
                            true, // артефакт старых ручек, сейчас всегда true
                            metrikaCrawlSamplesService.hasSamples(targetDomain, counterId),
                            counterInfo.getCounterName());
                    })
                .sorted(COUNTER_COMPARATOR)
                .collect(Collectors.toList());

        return new MetrikaCrawlSettingsResponse(crawlInfos);
    }
}
