package ru.yandex.webmaster3.viewer.http.metrika.crawl2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaCounterCrawlStateEnum;

/**
 * @author leonidrom
 */
public class UpdateMetrikaCrawlSettingsRequest extends AbstractUserVerifiedHostRequest {
    private long counterId;
    private boolean isEnabled;

    public long getCounterId() {
        return counterId;
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    @Description("Счетчик, состояние обхода по которому которого надо изменить")
    @RequestQueryProperty(required = true)
    public void setCounterId(long counterId) {
        this.counterId = counterId;
    }

    @Description("Включен ли обход по счетчику в новом состоянии")
    @RequestQueryProperty(required = true)
    public void setEnabled(boolean enabled) {
        isEnabled = enabled;
    }
}
