package ru.yandex.webmaster3.viewer.http.metrika.crawl2.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaCounterCrawlStateEnum;

/*
 * @author leonidrom
 */
public class MetrikaCounterCrawlInfo {
    private final long counterId;
    private final MetrikaCounterCrawlStateEnum crawlState;
    private final boolean verified;
    private final boolean hasUrlSamples;
    private final String name;

    public MetrikaCounterCrawlInfo(long counterId, MetrikaCounterCrawlStateEnum crawlState, boolean verified, boolean hasUrlSamples, String name) {
        this.counterId = counterId;
        this.crawlState = crawlState;
        this.verified = verified;
        this.hasUrlSamples = hasUrlSamples;
        this.name = name;
    }

    @Description("id счетчика метрики")
    public long getCounterId() {
        return counterId;
    }

    @Description("Текущее состояние обхода по счетчику")
    public MetrikaCounterCrawlStateEnum getCrawlState() {
        return crawlState;
    }

    @Description("Провязка счетчика с хостом подтверждена")
    public boolean isVerified() {
        return verified;
    }

    @Description("Для пары домен/счетчик есть семплы урлов, которые будут обходится")
    @JsonProperty("hasUrlSamples")
    public boolean hasUrlSamples() {
        return hasUrlSamples;
    }

    @Description("Название счетчика")
    public String getName() {
        return name;
    }
}
