package ru.yandex.webmaster3.viewer.http.mirrors;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * User: azakharov
 * Date: 06.07.15
 * Time: 18:21
 */
public class ChangeMainMirrorRequest extends AbstractUserVerifiedHostRequest {
    private WebmasterHostId newMainMirrorId;
    private boolean checkActionAvailability = false;

    public WebmasterHostId getNewMainMirrorId() {
        return newMainMirrorId;
    }

    @RequestQueryProperty(required = true)
    public void setNewMainMirrorId(WebmasterHostId newMainMirrorId) {
        this.newMainMirrorId = newMainMirrorId;
    }

    public boolean isCheckActionAvailability() {
        return checkActionAvailability;
    }

    @Description("Нужно ли проверять, что действие доступно для этого хоста (выставить в true при релизе WMC-2899)")
    @RequestQueryProperty
    public void setCheckActionAvailability(boolean checkActionAvailability) {
        this.checkActionAvailability = checkActionAvailability;
    }
}
