package ru.yandex.webmaster3.viewer.http.mirrors;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorRequest;
import ru.yandex.webmaster3.viewer.http.common.response.CommonHostInfo;

/**
 * User: azakharov
 * Date: 06.07.15
 * Time: 18:21
 */
public abstract class ChangeMainMirrorResponse implements ActionResponse {
    public static class OrdinaryResponse extends ChangeMainMirrorResponse implements ActionResponse.NormalResponse {
        private final MirrorRequest mainMirrorRequest;
        private final CommonHostInfo newMainMirrorHostInfo;
        private final CommonHostInfo oldMainMirrorHostInfo;

        public OrdinaryResponse(MirrorRequest mainMirrorRequest, CommonHostInfo newMainMirrorHostInfo, CommonHostInfo oldMainMirrorHostInfo) {
            this.mainMirrorRequest = mainMirrorRequest;
            this.newMainMirrorHostInfo = newMainMirrorHostInfo;
            this.oldMainMirrorHostInfo = oldMainMirrorHostInfo;
        }

        public MirrorRequest getMainMirrorRequest() {
            return mainMirrorRequest;
        }

        public CommonHostInfo getNewMainMirrorHostInfo() {
            return newMainMirrorHostInfo;
        }

        public CommonHostInfo getOldMainMirrorHostInfo() {
            return oldMainMirrorHostInfo;
        }
    }

    public enum ChangeMainMirrorErrorType {
        CHANGE_MAIN_MIRROR__INVALID_NEW_MAIN_HOST,
        CHANGE_MAIN_MIRROR__PREVIOUS_TASK_NOT_FINISHED,
        CHANGE_MAIN_MIRROR__SAME_TASK_WAITING,
        CHANGE_MAIN_MIRROR__DISALLOWED,
        CHANGE_MAIN_MIRROR__UNSUPPORTED_ACTION,
    }

    public abstract static class AbstractError extends ChangeMainMirrorResponse implements ActionResponse.ErrorResponse {
        private final ChangeMainMirrorErrorType code;

        public AbstractError(ChangeMainMirrorErrorType code) {
            this.code = code;
        }

        @Override
        public ChangeMainMirrorErrorType getCode() {
            return code;
        }
    }

    public static class InvalidNewMainHost extends AbstractError {
        public InvalidNewMainHost() {
            super(ChangeMainMirrorErrorType.CHANGE_MAIN_MIRROR__INVALID_NEW_MAIN_HOST);
        }
    }

    public static class PreviousTaskNotFinished extends AbstractError {
        public PreviousTaskNotFinished() {
            super(ChangeMainMirrorErrorType.CHANGE_MAIN_MIRROR__PREVIOUS_TASK_NOT_FINISHED);
        }
    }

    public static class SameTaskWaiting extends AbstractError {
        public SameTaskWaiting() {
            super(ChangeMainMirrorErrorType.CHANGE_MAIN_MIRROR__SAME_TASK_WAITING);
        }
    }

    public static class ChangeDisallowed extends AbstractError {
        private final String threat;

        public ChangeDisallowed(String threat) {
            super(ChangeMainMirrorErrorType.CHANGE_MAIN_MIRROR__DISALLOWED);
            this.threat = threat;
        }

        public String getThreat() {
            return threat;
        }
    }

    public static class UnsupportedAction extends AbstractError {
        public UnsupportedAction() {
            super(ChangeMainMirrorErrorType.CHANGE_MAIN_MIRROR__UNSUPPORTED_ACTION);
        }
    }
}
