package ru.yandex.webmaster3.viewer.http.mirrors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.checklist.data.SummarySiteProblemsInfo;
import ru.yandex.webmaster3.storage.checklist.service.SiteProblemsService;
import ru.yandex.webmaster3.storage.host.moderation.camelcase.service.DisplayNameService2;
import ru.yandex.webmaster3.storage.host.service.MirrorService2;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.common.response.CommonHostInfo;
import ru.yandex.webmaster3.viewer.http.user.GetHostListAction;

/**
 * User: azakharov
 * Date: 03.07.15
 * Time: 18:21
 */
@ReadAction
@Description("Ручка для получения главного зеркала")
@Category("mirrors")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/mirrors/main")
public class GetMainMirrorAction extends AbstractUserVerifiedHostAction<GetMainMirrorRequest, GetMainMirrorResponse> {

    private final DisplayNameService2 displayNameService2;
    private final MirrorService2 mirrorService2;
    private final SiteProblemsService siteProblemsService;

    @Override
    public GetMainMirrorResponse process(GetMainMirrorRequest request) {
        WebmasterHostId mainMirror = mirrorService2.getMainMirror(request.getHostId());
        if (mainMirror == null) {
            mainMirror = request.getHostId();
        }

        SummarySiteProblemsInfo rtProblems = siteProblemsService.getRealTimeProblemsSummary(mainMirror);
        String displayName = displayNameService2.getHostUrlWithDisplayName(request.getHostId());

        CommonHostInfo mainMirrorHostInfo = GetHostListAction.toCommonHostInfo(mainMirror, displayName, rtProblems, false);

        return new GetMainMirrorResponse.OrdinaryResponse(mainMirrorHostInfo);
    }
}
