package ru.yandex.webmaster3.viewer.http.mirrors;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorActionEnum;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorRequest;
import ru.yandex.webmaster3.viewer.http.common.response.CommonHostInfo;

/**
 * User: azakharov
 * Date: 08.07.15
 * Time: 20:10
 */
public abstract class GetMainMirrorChangeRequestsResponse implements ActionResponse {
    public static class OrdinaryResponse extends GetMainMirrorChangeRequestsResponse implements ActionResponse.NormalResponse {
        private final MirrorRequest mainMirrorRequest;
        private final CommonHostInfo newMainMirrorHostInfo;
        private final CommonHostInfo oldMainMirrorHostInfo;
        private final Boolean finished;
        private final MirrorActionEnum availableAction;

        public OrdinaryResponse(MirrorRequest mainMirrorRequest, CommonHostInfo newMainMirrorHostInfo,
                                CommonHostInfo oldMainMirrorHostInfo, Boolean finished, MirrorActionEnum availableAction) {
            this.mainMirrorRequest = mainMirrorRequest;
            this.newMainMirrorHostInfo = newMainMirrorHostInfo;
            this.oldMainMirrorHostInfo = oldMainMirrorHostInfo;
            this.finished = finished;
            this.availableAction = availableAction;
        }

        public MirrorRequest getMainMirrorRequest() {
            return mainMirrorRequest;
        }

        public CommonHostInfo getNewMainMirrorHostInfo() {
            return newMainMirrorHostInfo;
        }

        public CommonHostInfo getOldMainMirrorHostInfo() {
            return oldMainMirrorHostInfo;
        }

        public Boolean isFinished() {
            return finished;
        }

        @Description("действие, которое пользователь может запросить сейчас")
        public MirrorActionEnum getAvailableAction() {
            return availableAction;
        }
    }
}
