package ru.yandex.webmaster3.viewer.http.mirrors;

import lombok.RequiredArgsConstructor;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.mirrors.dao.MainMirrorRequestsYDao;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorRequest;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@WriteAction
@Description("Скрыть текущую обработанную заявку")
@Category("mirrors")
@RequiredArgsConstructor
public class HideMainMirrorRequestAction extends AbstractUserVerifiedHostAction<HideMainMirrorRequestRequest, HideMainMirrorRequestResponse> {
    private final MainMirrorRequestsYDao mainMirrorRequestsYDao;

    @Override
    public HideMainMirrorRequestResponse process(HideMainMirrorRequestRequest request) {
        try {
            MirrorRequest requestInfo = mainMirrorRequestsYDao.getLatestRequest(request.getHostId());
            if (requestInfo == null || !requestInfo.getRequestId().equals(request.getRequestId())) {
                return new HideMainMirrorRequestResponse.NormalResponse();
            }
            if (!requestInfo.getState().isTerminal()) {
                return new HideMainMirrorRequestResponse.BadRequestStateError();
            }
            mainMirrorRequestsYDao.saveRequest(requestInfo.hidden());
            return new HideMainMirrorRequestResponse.NormalResponse();
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to hide mirror request",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }
}
