package ru.yandex.webmaster3.viewer.http.mirrors;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class HideMainMirrorRequestResponse implements ActionResponse {
    public static class NormalResponse extends HideMainMirrorRequestResponse implements ActionResponse.NormalResponse {
    }

    public enum Errors {
        HIDE_MAIN_MIRROR_REQUEST__BAD_REQUEST_STATE,
    }

    @Description("Заявка не в терминальном состоянии")
    public static class BadRequestStateError extends HideMainMirrorRequestResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return Errors.HIDE_MAIN_MIRROR_REQUEST__BAD_REQUEST_STATE;
        }
    }
}
