package ru.yandex.webmaster3.viewer.http.mirrors;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorRequest;

/**
 * @author avhaliullin
 */
public abstract class UnstickMirrorResponse implements ActionResponse {
    public static class NormalResponse extends UnstickMirrorResponse implements ActionResponse.NormalResponse {
        private final MirrorRequest mainMirrorRequest;

        public NormalResponse(MirrorRequest mainMirrorRequest) {
            this.mainMirrorRequest = mainMirrorRequest;
        }

        public MirrorRequest getMainMirrorRequest() {
            return mainMirrorRequest;
        }
    }

    enum Errors {
        UNSTICK_MIRROR__UNSUPPORTED_ACTION,
        UNSTICK_MIRROR__PREVIOUS_TASK_NOT_FINISHED,
    }

    public abstract static class AbstractError extends UnstickMirrorResponse implements ActionResponse.ErrorResponse {
        private final Errors code;

        public AbstractError(Errors code) {
            this.code = code;
        }

        @Override
        public Errors getCode() {
            return code;
        }
    }

    public static class PreviousTaskNotFinished extends AbstractError {
        public PreviousTaskNotFinished() {
            super(Errors.UNSTICK_MIRROR__PREVIOUS_TASK_NOT_FINISHED);
        }
    }

    public static class UnsupportedAction extends AbstractError {
        public UnsupportedAction() {
            super(Errors.UNSTICK_MIRROR__UNSUPPORTED_ACTION);
        }
    }
}
