package ru.yandex.webmaster3.viewer.http.mirrors.generations;

import java.util.UUID;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.core.http.mirrors.PrepareNewMirrorGenerationResponse;
import ru.yandex.webmaster3.core.metrics.Category;

/**
 * @author tsyplyaev
 */
@WriteAction
@Category("internal")
@InternalAction
@Description("Подготовить обновление поколения")
public class PrepareNewMirrorGenerationAction extends Action<PrepareNewMirrorGenerationAction.Request, PrepareNewMirrorGenerationResponse> {
    @Override
    public PrepareNewMirrorGenerationResponse process(Request request) {
        try {
            //mirrorGenerationService.startPrepareGenerationsTask(request.getGenerationId());
        } catch (Exception ex) {
            //throw new WebmasterException("Could not start prepare generation task", new ActionError());
            return new PrepareNewMirrorGenerationResponse(ActionStatus.FAIL);
        }

        return new PrepareNewMirrorGenerationResponse(ActionStatus.SUCCESS);
    }

    public static class Request implements ActionRequest {
        private UUID generationId;

        @RequestQueryProperty(required = true)
        public void setGenerationId(UUID generationId) {
            this.generationId = generationId;
        }

        public UUID getGenerationId() {
            return generationId;
        }
    }
}
